package com.androidbook.simpledrawing;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.os.Bundle;
import android.view.View;

public class DrawBitmapActivity extends DrawingActivity {


	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(new ViewWithBitmap(this));
	}

	 private static class ViewWithBitmap extends View {
	        
	        public ViewWithBitmap(Context context) {
	            super(context);
	        }
	        
	        @Override protected void onDraw(Canvas canvas) {
	            canvas.drawColor(Color.BLUE);
	            
	            Bitmap jayPic = BitmapFactory.decodeResource(getResources(), R.drawable.bluejay);
	            
	            // Wyświeltalmy duże zdjęcie sójki po środku ekranu.
	            Bitmap jayPicMedium= Bitmap.createScaledBitmap(jayPic, 200, 300, false);           
	            canvas.drawBitmap(jayPicMedium, 60, 75, null);
	            
	            // Tworzymy miniaturkę.
	            Bitmap jayPicSmall= Bitmap.createScaledBitmap(jayPic, 50, 75, false);     
	         
	            Matrix maxTopLeft = new Matrix();
	            maxTopLeft.preRotate(30);

	            Matrix maxBottomLeft = new Matrix();
	            maxBottomLeft.preRotate(-30);
	            
	            Matrix maxTopRight = new Matrix();
	            maxTopRight.preRotate(-30);			// przekręcenie o 30 stopni w lewo
	            maxTopRight.preScale(-1, 1);		// odbicie lustrzane
	            
	            Matrix maxBottomRight = new Matrix();
	            maxBottomRight.preRotate(30);		// przekręcenie o 30 stopni w prawo
	            maxBottomRight.preScale(-1, 1);		// odbicie lustrzane

	            Bitmap jayPicTopLeft = Bitmap.createBitmap(jayPicSmall, 0, 0, jayPicSmall.getWidth(), jayPicSmall.getHeight(), maxTopLeft, false);
	            Bitmap jayPicBottomLeft = Bitmap.createBitmap(jayPicSmall, 0, 0, jayPicSmall.getWidth(), jayPicSmall.getHeight(), maxBottomLeft, false);

	            Bitmap jayPicTopRight = Bitmap.createBitmap(jayPicSmall, 0, 0, jayPicSmall.getWidth(), jayPicSmall.getHeight(), maxTopRight, false);
	            Bitmap jayPicBottomRight = Bitmap.createBitmap(jayPicSmall, 0, 0, jayPicSmall.getWidth(), jayPicSmall.getHeight(), maxBottomRight, false);
		           
	            // Zwolnienie pamięci poprzez usumięcie obrazków, które nie będą są już potrzebne.
	            jayPicSmall.recycle();
	            jayPic.recycle();
	            
	            canvas.drawBitmap(jayPicTopLeft, 30, 30, null);
	            canvas.drawBitmap(jayPicBottomLeft, 30, 325, null);
	            canvas.drawBitmap(jayPicTopRight, 225, 30, null);
	            canvas.drawBitmap(jayPicBottomRight, 225, 325, null);
	            
	            
	        }
	    }

}
